#!/usr/bin/perl -w

#Script to convert SQL INSERT statements into a tab-delimited text file
#suitable for importing to PostgreSQL using the COPY command.
#Assumes one row inserted per statement, one statement per line.

use Text::ParseWords;

if (!($ARGV[0])) {

        print "Usage: ./<scriptname> <datafile>\n";

        exit(1);

        }

open (INPUT, "$ARGV[0]") or die "Could not open input file: $!\n";

while ($line = <INPUT>) {

        if ($line =~ m/VALUES\s*\(\s*(.*)\s*\)/) {                      # capture insert string

                @fields = quotewords(',', 0, $1);                       # split insert string into fields

                $record = '';

                foreach $field (@fields) {

                        if ($field =~ m/\b[Nn][Uu][Ll][Ll]\b/) {        # delete NULL representations

                                $field = '';

                                }

                        $record = $record.$field."\t";                  # construct data string with tab delimiters

                        }

                chop $record;

                print $record, "\n";                                    # output tab delimited line
        }

}