------------------------------------------------------------------------------
-- Sample Symmetric Configuration
------------------------------------------------------------------------------
--
-- Nodes
--
delete from sym_node_group_link;
delete from sym_node_group;
delete from sym_node_identity;
delete from sym_node_security;
delete from sym_node;

--Se definen los nodos actores corp será el nodo root y store seran los nodos hijos
insert into sym_node_group (node_group_id, description) 
values ('symm_root', 'Nodo root');
insert into sym_node_group (node_group_id, description) 
values ('symm_client', 'Nodos clientes');

--Se define el modo de comunicación, siempre cliente se conectara a root para poner o sacar datos
insert into sym_node_group_link (source_node_group_id, target_node_group_id, data_event_action)
values ('symm_client', 'symm_root', 'P'); --P: source_node_group_id push data to target_node_group_id
insert into sym_node_group_link (source_node_group_id, target_node_group_id, data_event_action)
values ('symm_root', 'symm_client', 'W'); --W: waith for target_node_group_id to Pull data in to source_node_group_id

-- Only root node is defined manually, client nodes records are inserted by the system when client node registration is executed.
insert into sym_node (node_id, node_group_id, external_id, sync_enabled)
values ('symm_r', 'symm_root', 'symm_r', 1);
insert into sym_node_identity values ('symm_r');

--
-- Channels
-- You should creata as many chanals as you want depends on your way of grouping data.
--
insert into sym_channel 
(channel_id, processing_order, max_batch_size, enabled, description)
values('symm_chanel_head', 1, 500000, 1, 'Canal para la transmision de la cabeza');
insert into sym_channel 
(channel_id, processing_order, max_batch_size, enabled, description)
values('symm_chanel_child', 2, 500000, 1, 'Canal para la transmision de los hijos');

--
-- Triggers
-- You should create a triger per table to be invloved in the synchronize process.
--
insert into sym_trigger 
(trigger_id,source_table_name,channel_id,last_update_time,create_time, sync_on_incoming_batch)
values('symm_tipo_contacto_trg','tipo_contacto','symm_chanel_head',current_timestamp,current_timestamp,1);

insert into sym_trigger 
(trigger_id,source_table_name,channel_id,last_update_time,create_time, sync_on_incoming_batch)
values('symm_persona_trg','persona','symm_chanel_head',current_timestamp,current_timestamp,1);

insert into sym_trigger 
(trigger_id,source_table_name,channel_id,last_update_time,create_time, sync_on_incoming_batch)
values('symm_mascota_trg','mascota','symm_chanel_child',current_timestamp,current_timestamp,1);

insert into sym_trigger 
(trigger_id,source_table_name,channel_id,last_update_time,create_time, sync_on_incoming_batch)
values('symm_contacto_trg','contacto','symm_chanel_child',current_timestamp,current_timestamp,1);


-- Example of a "dead" trigger, which is used to only sync the table during initial load
--insert into sym_trigger 
--(trigger_id,source_table_name,channel_id, sync_on_insert, sync_on_update, sync_on_delete, last_update_time,create_time)
--values('sale_transaction_dead','sale_transaction','sale_transaction',0,0,0,current_timestamp,current_timestamp);

--
-- Routers
-- It is posible to route a table with conditionals, for example syncronize a row ony when a colum value is equal to a constant
-- in  our case, nombre=JUAN, in this case we should set router_type='column' and set router_expression='nombre=JUAN'
-- or we could set router_expression='NAME!=:OLD_NAME', in this case syncronize only when NAME column had changed.
-- Column name always be defined in upper case.
--

-- In this example, both routers pass everything all the time.
insert into sym_router 
(router_id,source_node_group_id,target_node_group_id,create_time,last_update_time)
values('root_client_router', 'symm_root', 'symm_client', current_timestamp, current_timestamp);

insert into sym_router 
(router_id,source_node_group_id,target_node_group_id,create_time,last_update_time)
values('client_root_router', 'symm_client', 'symm_root', current_timestamp, current_timestamp);

--
-- Trigger Router Links
-- One per table to be in the synchronized process
--
insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_tipo_contacto_trg','root_client_router',100,current_timestamp,current_timestamp);
insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_tipo_contacto_trg','client_root_router', 100, current_timestamp, current_timestamp);

insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_persona_trg','root_client_router',100,current_timestamp,current_timestamp);
insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_persona_trg','client_root_router', 100, current_timestamp, current_timestamp);

insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_mascota_trg','root_client_router',200,current_timestamp,current_timestamp);
insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_mascota_trg','client_root_router', 200, current_timestamp, current_timestamp);

insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_contacto_trg','root_client_router',200,current_timestamp,current_timestamp);
insert into sym_trigger_router 
(trigger_id,router_id,initial_load_order,last_update_time,create_time)
values('symm_contacto_trg','client_root_router', 200, current_timestamp, current_timestamp);




